(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to Get Xbot Status.
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * ReadFrame (Profinet reply frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands.
 * Xbot ID   (Any positive integer represent a particular Xbot.

 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE)
 * XbotState (Current Xbot State)
 * CurrentMode (Bit 0 to 5 represent the control mode of X, Y, Z, RX, Ry, RZ. 0 = position controlled mode, 1 = Force controlled mode)
 * CurrCmdLabel ( Current CmdLabel of executing command. If idle, returns 0xFFFF if idle)
 * MotionBuffer (Motion Buffer status. 0 = buffer unblocked, 1 = buffer blocked. Bit 15).
 * NumOfMotionCmd (Number of motion commands in buffer, Bit 0-14)
 * XPos (Current X Position [mm])
 * YPos (Current Y Position [mm])
 * ZPos (Current Z Position [mm])
 * RXPos (Current RX Position [mrad])
 * RYPos (Current RY Position [mrad])
 * RZPos (Current X Position [mrad])
 * GroupID (Group ID, if 0, Xbot is not in group)
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)





FUNCTION_BLOCK PM_GetXbotStatus
	
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 15  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
			
			XbotState 		:= ReadFrame[8];
			brsmemcpy(ADR(CurrCmdLabel),ADR(ReadFrame[9]),2);
			NumOfMotionCmd 	:= USINT_TO_UINT(ReadFrame[12]) + SHL(USINT_TO_UINT(ReadFrame[13]AND 127),8); // Read first part of UINT, Read second part except last bit. Shift bits to left
			MotionBuffer	:= SHR(ReadFrame[13],7);
			GroupID			:= ReadFrame[14];
				
			
			
			brsmemcpy(ADR(XPos),ADR(ReadFrame[15]),4);
			brsmemcpy(ADR(YPos),ADR(ReadFrame[19]),4);
			brsmemcpy(ADR(ZPos),ADR(ReadFrame[23]),4);
			brsmemcpy(ADR(RXPos),ADR(ReadFrame[27]),4);
			brsmemcpy(ADR(RYPos),ADR(ReadFrame[31]),4);
			brsmemcpy(ADR(RZPos),ADR(ReadFrame[35]),4);
			
			XPos := XPos*1000.0;
			YPos := YPos*1000.0;
			ZPos := ZPos*1000.0;
			RXPos := RXPos*1000.0;
			RYPos := RYPos*1000.0;
			RZPos := RZPos*1000.0;
			
			
			
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 15;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[9]		:= XbotID;
			Busy := TRUE;	
		END_IF;
		
	ELSIF(NOT(Execute))THEN
		Busy := FALSE;
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
